/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.PrintGraphics;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.image.BufferedImage;
import java.awt.print.PrinterGraphics;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.AttributedString;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.text.View;

public class UIUtils {
    public static final String OS_NAME;
    public static final boolean IS_LOW_RESOLUTION;
    private static final String JAVA_VERSION;
    private static final String JAVA_VERSION_STRING;
    private static final boolean IS_JAVA_5;
    private static final boolean IS_JAVA_6_OR_LATER;
    private static final String PROP_DESKTOPHINTS = "awt.font.desktophints";
    private static final String SWING_UTILITIES2_NAME;
    private static final int CHAR_BUFFER_SIZE = 100;
    private static final Object charsBufferLock;
    private static char[] charsBuffer;
    private static final FontRenderContext DEFAULT_FRC;
    private static Method drawStringMethod;
    private static Method drawStringUnderlineCharAtMethod;
    private static final boolean isOSX;

    public static boolean isMacOS() {
        return isOSX;
    }

    public static boolean isJava7OrLate() {
        return Integer.parseInt(JAVA_VERSION_STRING.substring(2)) > 6;
    }

    public static void drawRect(Graphics g, int x, int y, int w, int h) {
        g.fillRect(x, y, w + 1, 1);
        g.fillRect(x, y + 1, 1, h);
        g.fillRect(x + 1, y + h, w, 1);
        g.fillRect(x + w, y + 1, 1, h);
    }

    public static void drawStringUnderlineCharAt(JComponent c, Graphics g, String text, int underlinedIndex, int x, int y) {
        if (drawStringUnderlineCharAtMethod != null) {
            try {
                drawStringUnderlineCharAtMethod.invoke(null, c, g, text, new Integer(underlinedIndex), new Integer(x), new Integer(y));
                return;
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
        }
        Graphics2D g2 = (Graphics2D)g;
        Map oldRenderingHints = UIUtils.installDesktopHints(g2);
        BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, underlinedIndex, x, y);
        if (oldRenderingHints != null) {
            g2.addRenderingHints(oldRenderingHints);
        }
    }

    public static void drawString(JComponent c, Graphics g, String text, int x, int y) {
        if (drawStringMethod != null) {
            try {
                drawStringMethod.invoke(null, c, g, text, x, y);
                return;
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
        }
        Graphics2D g2 = (Graphics2D)g;
        Map oldRenderingHints = UIUtils.installDesktopHints(g2);
        BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, -1, x, y);
        if (oldRenderingHints != null) {
            g2.addRenderingHints(oldRenderingHints);
        }
    }

    private static Method getMethodDrawStringUnderlineCharAt() {
        try {
            Class<?> clazz = Class.forName(SWING_UTILITIES2_NAME);
            return clazz.getMethod("drawStringUnderlineCharAt", JComponent.class, Graphics.class, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (ClassNotFoundException e) {
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    private static Map installDesktopHints(Graphics2D g2) {
        Map desktopHints;
        HashMap<RenderingHints.Key, Object> oldRenderingHints = null;
        if (IS_JAVA_6_OR_LATER && (desktopHints = UIUtils.desktopHints(g2)) != null && !desktopHints.isEmpty()) {
            oldRenderingHints = new HashMap<RenderingHints.Key, Object>(desktopHints.size());
            for (Object o : desktopHints.keySet()) {
                RenderingHints.Key key = (RenderingHints.Key)o;
                oldRenderingHints.put(key, g2.getRenderingHint(key));
            }
            g2.addRenderingHints(desktopHints);
        }
        return oldRenderingHints;
    }

    private static Map desktopHints(Graphics2D g2) {
        Object aaHint;
        if (UIUtils.isPrinting(g2)) {
            return null;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        GraphicsDevice device = g2.getDeviceConfiguration().getDevice();
        Map desktopHints = (Map)toolkit.getDesktopProperty("awt.font.desktophints." + device.getIDstring());
        if (desktopHints == null) {
            desktopHints = (Map)toolkit.getDesktopProperty(PROP_DESKTOPHINTS);
        }
        if (desktopHints != null && ((aaHint = desktopHints.get(RenderingHints.KEY_TEXT_ANTIALIASING)) == RenderingHints.VALUE_TEXT_ANTIALIAS_OFF || aaHint == RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT)) {
            desktopHints = null;
        }
        return desktopHints;
    }

    private static Method getMethodDrawString() {
        try {
            Class<?> clazz = Class.forName(SWING_UTILITIES2_NAME);
            return clazz.getMethod("drawString", JComponent.class, Graphics.class, String.class, Integer.TYPE, Integer.TYPE);
        }
        catch (ClassNotFoundException e) {
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    private static boolean isPrinting(Graphics g) {
        return g instanceof PrintGraphics || g instanceof PrinterGraphics;
    }

    private static boolean startsWith(String str, String prefix) {
        return str != null && str.startsWith(prefix);
    }

    private static boolean isLowResolution() {
        try {
            return Toolkit.getDefaultToolkit().getScreenResolution() < 120;
        }
        catch (HeadlessException e) {
            return true;
        }
    }

    public static Icon getColorizedIcon(Icon icon, Color changeColor) {
        return UIUtils.getColorizedIcon(icon, Color.BLACK, changeColor);
    }

    public static Icon getColorizedIcon(Icon icon, Color searchColor, Color changeColor) {
        if (icon instanceof ImageIcon) {
            int colorRGB = changeColor.getRGB();
            BufferedImage image1 = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 6);
            BufferedImage image = (BufferedImage)((ImageIcon)icon).getImage();
            for (int m = 0; m < image.getWidth(); ++m) {
                for (int j = 0; j < image.getHeight(); ++j) {
                    int rgb = image.getRGB(m, j);
                    if (rgb != searchColor.getRGB()) continue;
                    image1.setRGB(m, j, colorRGB);
                }
            }
            return new ImageIcon(image1);
        }
        return icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String clipString(JComponent c, FontMetrics fm, String string, int availTextWidth) {
        String clipString = "...";
        int stringLength = string.length();
        if ((availTextWidth -= UIUtils.stringWidth(c, fm, clipString)) <= 0) {
            return clipString;
        }
        Object object = charsBufferLock;
        synchronized (object) {
            if (charsBuffer == null || charsBuffer.length < stringLength) {
                charsBuffer = string.toCharArray();
            } else {
                string.getChars(0, stringLength, charsBuffer, 0);
            }
        }
        AttributedString aString = new AttributedString(string);
        LineBreakMeasurer measurer = new LineBreakMeasurer(aString.getIterator(), DEFAULT_FRC);
        int nChars = measurer.nextOffset(availTextWidth);
        string = string.substring(0, nChars);
        return string + clipString;
    }

    public static int stringWidth(JComponent c, FontMetrics fm, String string) {
        if (string == null || string.equals("")) {
            return 0;
        }
        return fm.stringWidth(string);
    }

    public static boolean tabbedPaneChangeFocusTo(Component comp) {
        if (comp != null) {
            if (comp.isFocusable()) {
                UIUtils.compositeRequestFocus(comp);
                return true;
            }
            if (comp instanceof JComponent && ((JComponent)comp).requestDefaultFocus()) {
                return true;
            }
        }
        return false;
    }

    public static Component compositeRequestFocus(Component component) {
        if (component instanceof Container) {
            FocusTraversalPolicy policy;
            Component comp;
            FocusTraversalPolicy policy2;
            Component comp2;
            Container container = (Container)component;
            if (container.isFocusCycleRoot() && (comp2 = (policy2 = container.getFocusTraversalPolicy()).getDefaultComponent(container)) != null) {
                comp2.requestFocus();
                return comp2;
            }
            Container rootAncestor = container.getFocusCycleRootAncestor();
            if (rootAncestor != null && (comp = (policy = rootAncestor.getFocusTraversalPolicy()).getComponentAfter(rootAncestor, container)) != null && SwingUtilities.isDescendingFrom(comp, container)) {
                comp.requestFocus();
                return comp;
            }
        }
        if (component.isFocusable()) {
            component.requestFocus();
            return component;
        }
        return null;
    }

    public static String layoutCompoundLabel(JComponent c, FontMetrics fm, String text, Icon icon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewR, Rectangle iconR, Rectangle textR, int textIconGap) {
        boolean orientationIsLeftToRight = true;
        int hAlign = horizontalAlignment;
        int hTextPos = horizontalTextPosition;
        if (c != null && !c.getComponentOrientation().isLeftToRight()) {
            orientationIsLeftToRight = false;
        }
        switch (horizontalAlignment) {
            case 10: {
                hAlign = orientationIsLeftToRight ? 2 : 4;
                break;
            }
            case 11: {
                hAlign = orientationIsLeftToRight ? 4 : 2;
            }
        }
        switch (horizontalTextPosition) {
            case 10: {
                hTextPos = orientationIsLeftToRight ? 2 : 4;
                break;
            }
            case 11: {
                hTextPos = orientationIsLeftToRight ? 4 : 2;
            }
        }
        return UIUtils.layoutCompoundLabelImpl(c, fm, text, icon, verticalAlignment, hAlign, verticalTextPosition, hTextPos, viewR, iconR, textR, textIconGap);
    }

    private static String layoutCompoundLabelImpl(JComponent c, FontMetrics fm, String text, Icon icon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewR, Rectangle iconR, Rectangle textR, int textIconGap) {
        int gap;
        if (icon != null) {
            iconR.width = icon.getIconWidth();
            iconR.height = icon.getIconHeight();
        } else {
            iconR.height = 0;
            iconR.width = 0;
        }
        boolean textIsEmpty = text == null || text.equals("");
        int lsb = 0;
        int rsb = 0;
        View v = null;
        if (textIsEmpty) {
            textR.height = 0;
            textR.width = 0;
            text = "";
            gap = 0;
        } else {
            gap = icon == null ? 0 : textIconGap;
            int availTextWidth = horizontalTextPosition == 0 ? viewR.width : viewR.width - (iconR.width + gap);
            View view = v = c != null ? (View)c.getClientProperty("html") : null;
            if (v != null) {
                textR.width = Math.min(availTextWidth, (int)v.getPreferredSpan(0));
                textR.height = (int)v.getPreferredSpan(1);
            } else {
                StringTokenizer tokenizer = new StringTokenizer(text, "\n");
                int countTokens = tokenizer.countTokens();
                for (int i = 0; i < countTokens; ++i) {
                    String token = tokenizer.nextToken();
                    textR.width = Math.max(UIUtils.stringWidth(c, fm, token), textR.width);
                    if (textR.width <= availTextWidth) continue;
                    text = UIUtils.clipString(c, fm, text, availTextWidth);
                    textR.width = UIUtils.stringWidth(c, fm, token);
                }
                textR.height = fm.getHeight() * countTokens;
            }
        }
        textR.y = verticalTextPosition == 1 ? (horizontalTextPosition != 0 ? 0 : -(textR.height + gap)) : (verticalTextPosition == 0 ? iconR.height / 2 - textR.height / 2 : (horizontalTextPosition != 0 ? iconR.height - textR.height : iconR.height + gap));
        textR.x = horizontalTextPosition == 2 ? -(textR.width + gap) : (horizontalTextPosition == 0 ? iconR.width / 2 - textR.width / 2 : iconR.width + gap);
        int labelR_x = Math.min(iconR.x, textR.x);
        int labelR_width = Math.max(iconR.x + iconR.width, textR.x + textR.width) - labelR_x;
        int labelR_y = Math.min(iconR.y, textR.y);
        int labelR_height = Math.max(iconR.y + iconR.height, textR.y + textR.height) - labelR_y;
        int dy = verticalAlignment == 1 ? viewR.y - labelR_y : (verticalAlignment == 0 ? viewR.y + viewR.height / 2 - (labelR_y + labelR_height / 2) : viewR.y + viewR.height - (labelR_y + labelR_height));
        int dx = horizontalAlignment == 2 ? viewR.x - labelR_x : (horizontalAlignment == 4 ? viewR.x + viewR.width - (labelR_x + labelR_width) : viewR.x + viewR.width / 2 - (labelR_x + labelR_width / 2));
        textR.x += dx;
        textR.y += dy;
        iconR.x += dx;
        iconR.y += dy;
        if (lsb < 0) {
            textR.x -= lsb;
            textR.width += lsb;
        }
        if (rsb > 0) {
            textR.width -= rsb;
        }
        return text;
    }

    public static Dimension getPreferredButtonSize(AbstractButton b, int textIconGap) {
        if (b.getComponentCount() > 0) {
            return null;
        }
        Icon icon = b.getIcon();
        String text = b.getText();
        Font font = b.getFont();
        FontMetrics fm = b.getFontMetrics(font);
        Rectangle iconR = new Rectangle();
        Rectangle textR = new Rectangle();
        Rectangle viewR = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
        UIUtils.layoutCompoundLabel(b, fm, text, icon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewR, iconR, textR, text == null ? 0 : textIconGap);
        Rectangle r = iconR.union(textR);
        Insets insets = b.getInsets();
        r.width += insets.left + insets.right;
        r.height += insets.top + insets.bottom;
        return r.getSize();
    }

    static {
        IS_LOW_RESOLUTION = UIUtils.isLowResolution();
        JAVA_VERSION = System.getProperty("java.version");
        JAVA_VERSION_STRING = JAVA_VERSION.substring(0, 3);
        IS_JAVA_5 = UIUtils.startsWith(JAVA_VERSION, "1.5");
        IS_JAVA_6_OR_LATER = !IS_JAVA_5;
        SWING_UTILITIES2_NAME = IS_JAVA_6_OR_LATER ? "sun.swing.SwingUtilities2" : "com.sun.java.swing.SwingUtilities2";
        charsBufferLock = new Object();
        charsBuffer = new char[100];
        DEFAULT_FRC = new FontRenderContext(null, false, false);
        drawStringMethod = null;
        drawStringUnderlineCharAtMethod = null;
        OS_NAME = System.getProperty("os.name");
        drawStringMethod = UIUtils.getMethodDrawString();
        drawStringUnderlineCharAtMethod = UIUtils.getMethodDrawStringUnderlineCharAt();
        isOSX = OS_NAME.toLowerCase().startsWith("mac os");
    }
}

