/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.socialmedia.io.messagefinder.youtube;

import com.agilemind.commons.util.StringUtil;
import com.agilemind.socialmedia.io.data.enums.MessageType;
import com.agilemind.socialmedia.io.data.enums.ReplyStatus;
import com.agilemind.socialmedia.io.data.enums.ServiceType;
import com.agilemind.socialmedia.io.data.enums.StreamType;
import com.agilemind.socialmedia.io.data.reach.ReachType;
import com.agilemind.socialmedia.io.data.reach.metric.YoutubeRMetric;
import com.agilemind.socialmedia.io.messagefinder.MessageResult;
import com.agilemind.socialmedia.util.SocialMediaStringKey;
import com.google.api.services.youtube.model.Channel;
import com.google.api.services.youtube.model.ChannelSnippet;
import com.google.api.services.youtube.model.Comment;
import com.google.api.services.youtube.model.CommentSnippet;
import com.google.api.services.youtube.model.CommentThread;
import com.google.api.services.youtube.model.CommentThreadReplies;
import com.google.api.services.youtube.model.CommentThreadSnippet;
import com.google.api.services.youtube.model.ThumbnailDetails;
import com.google.api.services.youtube.model.Video;
import com.google.api.services.youtube.model.VideoContentDetails;
import com.google.api.services.youtube.model.VideoSnippet;
import com.google.api.services.youtube.model.VideoStatistics;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class YoutubeParser {
    public static boolean b;
    private static final String[] a;

    public static MessageResult parseVideo(Video video, Channel channel, StreamType streamType) throws IOException {
        return YoutubeParser.parseVideo(video, channel, streamType, null);
    }

    public static MessageResult parseVideo(Video video, Channel channel, StreamType streamType, String string) throws IOException {
        boolean bl = b;
        String string2 = video.getId();
        String string3 = YoutubeParser.a(string2);
        VideoSnippet videoSnippet = video.getSnippet();
        MessageResult messageResult = new MessageResult(string3, new Date(videoSnippet.getPublishedAt().getValue()));
        messageResult.setFirstMessageOfContainer(true);
        messageResult.setText(StringUtil.getStringOrEmpty((String)videoSnippet.getDescription()));
        messageResult.setContainerText(StringUtil.getStringOrEmpty((String)videoSnippet.getTitle()));
        messageResult.setId(string2);
        messageResult.setContainerUrl(string3);
        ChannelSnippet channelSnippet = channel.getSnippet();
        messageResult.setAuthor(channelSnippet.getTitle());
        messageResult.setAvatarUrl(channelSnippet.getThumbnails().getDefault().getUrl());
        messageResult.setAccountId(videoSnippet.getChannelId());
        messageResult.setRecipientAccountId(string);
        VideoContentDetails videoContentDetails = video.getContentDetails();
        String string4 = videoContentDetails.getDuration();
        messageResult.putAdditionalParameter(a[1], String.valueOf(YoutubeParser.b(string4.substring(2))));
        ThumbnailDetails thumbnailDetails = videoSnippet.getThumbnails();
        messageResult.putAdditionalParameter(a[0], thumbnailDetails.getDefault().getUrl());
        messageResult.putAdditionalParameter(a[3], string2);
        messageResult.putAdditionalParameter(a[2], ReachType.YT_VIDEO.getKey());
        messageResult.setReplyStatus(ReplyStatus.OPEN);
        messageResult.setServiceType(ServiceType.YOU_TUBE);
        messageResult.setMessageType(MessageType.YOUTUBE_VIDEO);
        messageResult.setStreamType(streamType);
        VideoStatistics videoStatistics = video.getStatistics();
        BigInteger bigInteger = videoStatistics.getViewCount();
        if (bigInteger != null) {
            messageResult.putAdditionalParameter(a[4], String.valueOf(bigInteger));
        }
        BigInteger bigInteger2 = videoStatistics.getLikeCount();
        if (bigInteger2 != null) {
            messageResult.putAdditionalParameter(YoutubeRMetric.LIKES.getKey(), String.valueOf(bigInteger2));
        }
        BigInteger bigInteger3 = videoStatistics.getDislikeCount();
        if (bigInteger3 != null) {
            messageResult.putAdditionalParameter(YoutubeRMetric.DISLIKES.getKey(), String.valueOf(bigInteger3));
        }
        BigInteger bigInteger4 = videoStatistics.getCommentCount();
        if (bigInteger4 != null) {
            messageResult.putAdditionalParameter(YoutubeRMetric.COMMENTS.getKey(), String.valueOf(bigInteger4));
        }
        if (bl) {
            int n2 = SocialMediaStringKey.b;
            SocialMediaStringKey.b = ++n2;
        }
        return messageResult;
    }

    public static List<MessageResult> parseCommentThread(CommentThread commentThread, StreamType streamType) {
        boolean bl = b;
        ArrayList<MessageResult> arrayList = new ArrayList<MessageResult>();
        CommentThreadSnippet commentThreadSnippet = commentThread.getSnippet();
        String string = commentThreadSnippet.getVideoId();
        MessageResult messageResult = YoutubeParser.parseComment(commentThreadSnippet.getTopLevelComment(), string, streamType);
        if (messageResult != null) {
            arrayList.add(messageResult);
        }
        CommentThreadReplies commentThreadReplies = commentThread.getReplies();
        if (commentThreadReplies == null) {
            return arrayList;
        }
        for (Comment comment : commentThreadReplies.getComments()) {
            MessageResult messageResult2 = YoutubeParser.parseComment(comment, string, streamType);
            if (messageResult2 != null) {
                arrayList.add(messageResult2);
            }
            if (!bl) continue;
        }
        return arrayList;
    }

    public static MessageResult parseComment(Comment comment, String string, StreamType streamType) {
        return YoutubeParser.parseComment(comment, null, string, streamType);
    }

    public static MessageResult parseComment(Comment comment, String string, String string2, StreamType streamType) {
        Object object;
        CommentSnippet commentSnippet = comment.getSnippet();
        String string3 = comment.getId();
        String string4 = YoutubeParser.a(string2, string3);
        MessageResult messageResult = new MessageResult(string4, new Date(commentSnippet.getPublishedAt().getValue()));
        messageResult.setId(string3);
        messageResult.setContainerUrl(YoutubeParser.a(string2));
        String string5 = commentSnippet.getTextOriginal();
        if (string5 == null) {
            string5 = commentSnippet.getTextDisplay();
        }
        messageResult.setText(StringUtil.getStringOrEmpty((String)string5));
        messageResult.setContainerText(StringUtil.getStringOrEmpty((String)string5));
        String string6 = string;
        if (string6 == null && (object = commentSnippet.getAuthorChannelId()) != null) {
            string6 = object.getValue();
        }
        if (string6 == null) {
            return null;
        }
        messageResult.setAccountId(string6);
        messageResult.setAvatarUrl(commentSnippet.getAuthorProfileImageUrl());
        messageResult.setAuthor(commentSnippet.getAuthorDisplayName());
        messageResult.putAdditionalParameter(a[5], string2);
        object = commentSnippet.getParentId();
        if (object != null) {
            messageResult.putAdditionalParameter(a[6], (String)object);
        }
        messageResult.setReplyStatus(ReplyStatus.OPEN);
        messageResult.setServiceType(ServiceType.YOU_TUBE);
        messageResult.setMessageType(MessageType.YOUTUBE_COMMENT);
        messageResult.setStreamType(streamType);
        return messageResult;
    }

    private static String a(String string) {
        return a[7] + string;
    }

    private static String a(String string, String string2) {
        return YoutubeParser.a(string) + "_" + string2;
    }

    private static int b(String string) throws IllegalArgumentException {
        int n2;
        block23: {
            block22: {
                if (string.length() != 0 && !string.contains("-")) break block22;
                throw new IllegalArgumentException();
            }
            if (string.endsWith("H") || string.endsWith("M")) break block23;
            if (string.endsWith("S")) break block23;
            throw new IllegalArgumentException();
        }
        int n3 = 0;
        int n4 = string.indexOf("H");
        if (n3 == n4) {
            throw new IllegalArgumentException();
        }
        int n5 = 0;
        if (n4 != -1) {
            n2 = Integer.parseInt(string.substring(0, n4));
            n5 += n2 * 3600;
            n3 = n4 + 1;
        }
        n4 = string.indexOf("M");
        if (n3 == n4) {
            throw new IllegalArgumentException();
        }
        if (n4 != -1) {
            n2 = Integer.parseInt(string.substring(n3, n4));
            n5 += n2 * 60;
            n3 = n4 + 1;
        }
        n4 = string.indexOf("S");
        if (n3 == n4) {
            throw new IllegalArgumentException();
        }
        if (n4 != -1) {
            n2 = Math.round(Integer.parseInt(string.substring(n3, n4)) * 100) / 100;
            n5 += n2;
        }
        return n5;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[8];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "0+\\\u001eo*\"@\u001f";
        int n3 = -1;
        block15: while (true) {
            char[] cArray;
            block20: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block19: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block19;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block20;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 68;
                                break;
                            }
                            case 1: {
                                n9 = 67;
                                break;
                            }
                            case 2: {
                                n9 = 41;
                                break;
                            }
                            case 3: {
                                n9 = 115;
                                break;
                            }
                            default: {
                                n9 = 13;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\u0000\u0016{2Y\r\fg";
                    n3 = 0;
                    continue block15;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "\u0016\u0006h0E\u001b\u0017p#H";
                    n3 = 1;
                    continue block15;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "2*M\u0016b\r'";
                    n3 = 2;
                    continue block15;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "\u0012\nl$R\u0007\f|=Y";
                    n3 = 3;
                    continue block15;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "2*M\u0016b\r'";
                    n3 = 4;
                    continue block15;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "\u0014\u0002{6C\u0010\u001c`7";
                    n3 = 5;
                    continue block15;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = ",7]\u0003~~l\u0006\u0004z3mP\u001cx06K\u0016#',D\\z%7J\u001b22~";
                    n3 = 6;
                    continue block15;
                }
                case 6: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        a = stringArray3;
    }
}

