/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.socialmedia.io.socialservices;

import com.agilemind.commons.io.pagereader.PageReader;
import com.agilemind.commons.util.OperationLogger;
import com.agilemind.socialmedia.io.data.enums.MessageType;
import com.agilemind.socialmedia.io.messagefinder.MessageResult;
import com.agilemind.socialmedia.io.socialservices.AccountCredential;
import com.agilemind.socialmedia.io.socialservices.FactorValueGetter;
import com.agilemind.socialmedia.io.socialservices.ReachDataUpdater;
import com.agilemind.socialmedia.io.socialservices.a;
import com.agilemind.socialmedia.io.socialservices.blogs.BlogReachDataUpdater;
import com.agilemind.socialmedia.io.socialservices.facebook.FacebookReachDataUpdater;
import com.agilemind.socialmedia.io.socialservices.forums.ForumReachDataUpdater;
import com.agilemind.socialmedia.io.socialservices.googleplus.GooglePlusReachDataUpdater;
import com.agilemind.socialmedia.io.socialservices.linkedin.LinkedInReachDataUpdater;
import com.agilemind.socialmedia.io.socialservices.twitter.TwitterReachDataUpdater;
import com.agilemind.socialmedia.io.socialservices.vkontakte.VKonktakteReachDataUpdater;
import com.agilemind.socialmedia.io.utils.CaptchaRequester;
import java.io.IOException;
import java.util.Map;
import java.util.WeakHashMap;

public class ReachInfoUpdaterUtil {
    private static final Map<MessageType, ReachDataUpdater> a = new WeakHashMap<MessageType, ReachDataUpdater>();

    public static void updateReachData(MessageResult messageResult, PageReader pageReader, CaptchaRequester captchaRequester, FactorValueGetter factorValueGetter, OperationLogger operationLogger) throws InterruptedException, IOException {
        ReachDataUpdater reachDataUpdater = ReachInfoUpdaterUtil.a(messageResult);
        reachDataUpdater.updateReachData(messageResult, pageReader, captchaRequester, factorValueGetter, operationLogger);
    }

    private static ReachDataUpdater a(MessageResult messageResult) {
        MessageType messageType = messageResult.getMessageType();
        ReachDataUpdater reachDataUpdater = a.get((Object)messageType);
        if (reachDataUpdater == null) {
            reachDataUpdater = ReachInfoUpdaterUtil.b(messageResult);
            a.put(messageType, reachDataUpdater);
        }
        return reachDataUpdater;
    }

    private static ReachDataUpdater b(MessageResult messageResult) {
        ReachDataUpdater reachDataUpdater;
        boolean bl = AccountCredential.c;
        MessageType messageType = messageResult.getMessageType();
        switch (messageType) {
            case BLOG_POST: {
                reachDataUpdater = new BlogReachDataUpdater();
                if (!bl) break;
            }
            case FORUM_POST: {
                reachDataUpdater = new ForumReachDataUpdater();
                if (!bl) break;
            }
            case GOOGLE_PLUS_POST: {
                reachDataUpdater = new GooglePlusReachDataUpdater();
                if (!bl) break;
            }
            case LINKED_IN_POST: {
                reachDataUpdater = new LinkedInReachDataUpdater();
                if (!bl) break;
            }
            case VK_MESSAGE: {
                reachDataUpdater = new VKonktakteReachDataUpdater();
                if (!bl) break;
            }
            case FACEBOOK_MESSAGE: {
                reachDataUpdater = new FacebookReachDataUpdater();
                if (!bl) break;
            }
            case TWEET: {
                reachDataUpdater = new TwitterReachDataUpdater();
                if (!bl) break;
            }
            default: {
                reachDataUpdater = new a();
            }
        }
        return reachDataUpdater;
    }
}

